// Copyright (c) 2026 Huntr Software LLC
// SPDX-License-Identifier: MIT

#ifndef LSTRING_H
#define LSTRING_H

#include <string>
#include <vector>
#include <algorithm>
#include "layers_global.h"

LAYERS_NAMESPACE_BEGIN

/*
	Type alias for std::string used throughout the Layers framework.
*/
using LString = std::string;

/*
	Type alias for a vector of strings.
*/
using LStringList = std::vector<std::string>;

/*
	Checks if a string starts with the given prefix.

	Returns true if str begins with prefix, false otherwise.
*/
inline bool starts_with(const LString& str, const LString& prefix)
{
    return str.rfind(prefix, 0) == 0;
}

/*
	Removes the first occurrence of a substring from a string.

	Returns a new string with the first occurrence of sub removed.
	If sub is not found, returns a copy of the original string.
*/
inline LString remove_substring(LString str, const std::string& sub)
{
    if (sub.empty()) return str;
    size_t pos = str.find(sub);
    if (pos != std::string::npos)
        str.erase(pos, sub.length());
    return str;
}

LAYERS_NAMESPACE_END

#endif // LSTRING_H
