// Copyright (c) 2026 Huntr Software LLC
// SPDX-License-Identifier: MIT

#ifndef LLOGGER_H
#define LLOGGER_H

#include "layers_global.h"
#include "layers_exports.h"

#include "lstring.h"

LAYERS_NAMESPACE_BEGIN

/*
	Function pointer type for custom log message handlers.

	Applications can provide their own logging function to integrate
	with existing logging systems.
*/
using LogFunction = void(*)(const LString& message);

/*
	Sets a custom logging function.

	The provided function will be called whenever log() is invoked.
	Pass nullptr to disable logging.
*/
LAYERS_EXPORT void set_log_function(LogFunction fn);

/*
	Logs a message using the configured log function.

	If no custom log function is set, the message is discarded.
*/
LAYERS_EXPORT void log(const LString& message);

LAYERS_NAMESPACE_END

#endif // LLOGGER_H
