// Copyright (c) 2026 Huntr Software LLC
// SPDX-License-Identifier: MIT

#ifndef LGENERATE_H
#define LGENERATE_H

#include <random>
#include <string>
#include <sstream>
#include <iomanip>

#include "layers_global.h"
#include "layers_exports.h"

#include "lstring.h"

LAYERS_NAMESPACE_BEGIN

/*
	Generates a random UUID (Universally Unique Identifier) string.

	Returns a string in the format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
	where each x is a hexadecimal digit.
*/
LAYERS_EXPORT inline LString generate_uuid()
{
    std::random_device rd;
    std::mt19937 gen(rd());
    std::uniform_int_distribution<> dis(0, 255);

    std::stringstream ss;
    ss << std::hex << std::setfill('0');

    for (int i = 0; i < 16; ++i) {
        ss << std::setw(2) << dis(gen);
        if (i == 3 || i == 5 || i == 7 || i == 9) {
            ss << "-";
        }
    }

    return ss.str();
}

LAYERS_NAMESPACE_END

#endif // !LGENERATE_H
