// Copyright (c) 2026 Huntr Software LLC
// SPDX-License-Identifier: MIT

#ifndef LAYERS_EXPORTS_H
#define LAYERS_EXPORTS_H

/*
	Platform-specific export/import macros for building Layers as a shared library.

	LAYERS_EXPORT is used to mark symbols for export in shared libraries.
	Handles platform-specific DLL export/import declarations for Windows and
	symbol visibility for other platforms.
*/

// Platform-specific checks
#if defined(_WIN32) || defined(_WIN64)
	#define LAYERS_WINDOWS
#endif

// Dynamic linkage handling
#ifndef BUILD_STATIC
	#ifdef LAYERS_WINDOWS
		#ifdef LAYERS_LIB
			#define LAYERS_EXPORT __declspec(dllexport)
		#else
			#define LAYERS_EXPORT __declspec(dllimport)
		#endif
	#else
		#ifdef LAYERS_LIB
			#define LAYERS_EXPORT __attribute__((visibility("default")))
		#else
			#define LAYERS_EXPORT
		#endif
	#endif
#else
	#define LAYERS_EXPORT
#endif

#endif // LAYERS_EXPORTS_H
